function [N,J,L,W,H,Ud,Vd,P,Q,C_bar] = Proposed_observer(A,B,F,D1,C,D2)

[n,q] = size(D1);
[p,~] = size(C);
[~,l] = size(F);

r = rank(D2);

% SVD for D2
    [Ud, Sd, Vd] = svd(D2); % Ud p*p, Sd p*q, Vd q*q 
    D1_r = D1*Vd;
    D11 = D1_r*[eye(r); zeros(q-r,r)];
    D12 = D1_r*[zeros(r,r); eye(q-r)];
    C_tilde = Ud'*C;
    
    D1_bar_r = D11;
    D2_bar_r = Sd*[eye(r); zeros(q-r, r)];

% Descriptor formulation
    E_bar = [eye(n) zeros(n,r)]; % 
    A_bar = [A D1_bar_r]; 
    B_bar = B; 
    F_bar = [F D12];
    C_bar = [C_tilde D2_bar_r];

% Parametrization
Omega_1 = [E_bar;C_bar]; 

Xi_1 = eye(n+r);
Omega_2 = [eye(n+r); C_bar];

varGamma_1 = eye(n+p) - Omega_1*pinv(Omega_1);
T1 = Xi_1*pinv(Omega_1)*[eye(n); zeros(p,n)];
T2 = varGamma_1*[eye(n); zeros(p,n)];

H1 = Xi_1*pinv(Omega_1)*[zeros(n,p);eye(p)];
H2 = varGamma_1*[zeros(n,p);eye(p)];

varGamma_2 = eye(n+r+p) - Omega_2*pinv(Omega_2);
N2 = varGamma_2*[eye(n+r); zeros(p,n+r)];
bar_L2 = varGamma_2*[zeros(n+r,p);eye(p)];

varPhi = A_bar*pinv(Omega_2)*[eye(n+r); zeros(p,n+r)];
T2_hat = [T2; zeros(n+r+p, n)];
T2N = [T2*varPhi; N2];

alpha = 1;

% Solve LMI using Yalmip
P0 = sdpvar(n+r,n+r);
Q0 = sdpvar(p,l+q-r, 'full');
M0 = sdpvar(n+r,2*n+2*p+r, 'full');

Const = [];
Const = [Const, P0 >= eps*eye(n+r)];
Const = [Const, (P0*T1*varPhi - M0*T2N) + (P0*T1*varPhi - M0*T2N)' + 2*alpha*P0 <= -eps*eye(n+r)];  
Const = [Const, (P0*T1 - M0*T2_hat)*F_bar == C_bar'*Q0];

options = sdpsettings('solver', 'mosek','verbose',1);
optimize(Const, [], options); 
P = value(P0);
M = value(M0);
Q = value(Q0);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

Y = inv(P)*M;
Y1 = Y*[eye(n+p); zeros(n+r+p,n+p)]; 
Y2 = Y*[zeros(n+p,n+r+p);eye(n+r+p)];

T = T1 - Y1*T2;
H = H1 - Y1*H2;

Xi2 = T*A_bar;
N1 = Xi2*pinv(Omega_2)*[eye(n+r); zeros(p,n+r)];
bar_L1 = Xi2*pinv(Omega_2)*[zeros(n+r,p); eye(p)];
N = N1 - Y2*N2;
bar_L = bar_L1 - Y2*bar_L2;
L = bar_L + N*H;

J = T*B_bar;
W = inv(P)*C_bar';

